/*
 * PhidgetControlPanel.java
 *
 * Created on October 29, 2007, 11:11 AM
 */

package PhidgetControlPanel;

import com.phidgets.Manager;
import com.phidgets.Phidget;
import com.phidgets.PhidgetException;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JOptionPane;
import listeners.*;

/**
 *
 * @author  Owner
 */
public class PhidgetControlPanel extends javax.swing.JFrame {
    
    private Manager manager;
    private ManagerAttachListener attach_listener;
    private ManagerDetachListener detach_listener;
    private String name_list[][];
    
    /**
     * Creates new form PhidgetControlPanel
     */
    public PhidgetControlPanel() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        deviceTbl = new javax.swing.JTable();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("PhidgetControlPanel");
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosed(java.awt.event.WindowEvent evt) {
                formWindowClosed(evt);
            }
            public void windowOpened(java.awt.event.WindowEvent evt) {
                formWindowOpened(evt);
            }
        });

        jLabel1.setFont(new java.awt.Font("Tahoma", 1, 12));
        jLabel1.setText("Status");

        jLabel2.setFont(new java.awt.Font("Tahoma", 1, 12));
        jLabel2.setText("Library Information");

        jLabel3.setText("jLabel3");

        deviceTbl.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Device Name", "Serial No.", "Version", "Attached"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.String.class
            };
            boolean[] canEdit = new boolean [] {
                false, false, false, false
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jScrollPane1.setViewportView(deviceTbl);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(21, 21, 21)
                        .add(jLabel3))
                    .add(layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jLabel2))
                    .add(layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jLabel1))
                    .add(layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 475, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 130, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel2)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel3)
                .addContainerGap(35, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    
    private String nameToExample(String name)
    {
        if((name.compareTo("Phidget Servo Controller 1-motor") == 0) || 
                (name.compareTo("Phidget Servo Controller 4-motor") == 0))
        {
            return "Servo-full.jar";
        }
        else if((name.compareTo("Phidget InterfaceKit 8/8/8") == 0) || 
                (name.compareTo("Phidget InterfaceKit 0/0/4") == 0) || 
                (name.compareTo("Phidget InterfaceKit 0/16/16") == 0) || 
                (name.compareTo("Phidget InterfaceKit 0/5/7") == 0) ||
                (name.compareTo("Phidget InterfaceKit 0/8/8") == 0) || 
                (name.compareTo("Phidget InterfaceKit 0/0/8") == 0) || 
                (name.compareTo("Phidget Joystick Interface Kit") == 0) || 
                (name.compareTo("Phidget Touch Slider") == 0) || 
                (name.compareTo("Phidget Touch Rotation") == 0))
        {
            return "InterfaceKit-full.jar";
        }
        else if((name.compareTo("Phidget Accelerometer 2-axis") == 0) || 
                (name.compareTo("Phidget Accelerometer 3-axis") == 0))
        {
            return "Accelerometer-full.jar";
        }
        else if((name.compareTo("Phidget TextLCD Custom") == 0) || 
                (name.compareTo("Phidget TextLCD") == 0))
        {
            return "TextLCD-full.jar";
        }
        else if((name.compareTo("Phidget RFID") == 0) || 
                (name.compareTo("Phidget RFID 2-output") == 0))
        {
            return "RFID-full.jar";
        }
        else if((name.compareTo("Phidget Low Voltage Motor Controller 2-motor 4-input") == 0) ||
                (name.compareTo("Phidget High Current Motor Controller 2-motor") == 0))
        {
            return "MotorControl-full.jar";
        }
        else if(name.compareTo("Phidget Temperature Sensor") == 0)
        {
            return "TemperatureSensor-full.jar";
        }
        else if(name.compareTo("Phidget LED 64") == 0)
        {
            return "LED-full.jar";
        }
        else if((name.compareTo("Phidget Stepper") == 0) ||
                (name.compareTo("Phidget Unipolar Stepper Controller 4-motor") == 0) || 
                (name.compareTo("Phidget Bipolar Stepper Controller 1-motor") == 0))
        {
            return "Stepper-full.jar";
        }
        else if((name.compareTo("Phidget Encoder 1-encoder 1-input") == 0) ||
                (name.compareTo("Phidget High Speed Encoder 1-encoder") == 0) ||
                (name.compareTo("Phidget Encoder 4-encoder 4-input") == 0))
        {
            return "Encoder-full.jar";
        }
        else if(name.compareTo("Phidget PH Sensor") == 0)
        {
            return "PHSensor-full.jar";
        }
        else if(name.compareTo("Phidget Advanced Servo Controller 8-motor") == 0)
        {
            return "AdvancedServo-full.jar";
        }
        else
        {
            return "PhidgetControlPanel-full.jar";
        }
    }
    private void deviceTblMouseDblClicked(int row, int col) {
        String serialNum = (String)deviceTbl.getModel().getValueAt(row, 1);
        String deviceName = (String)deviceTbl.getModel().getValueAt(row, 0);
        
        String example = nameToExample(deviceName);
        String rundir = System.getProperty ("user.dir");
        
        String command = "java";
        
        String arg1 = "-jar";
        String arg2 = "" + rundir + "\\" + example;
        String arg3 = serialNum;
        
        try
        {
            ProcessBuilder pb = new ProcessBuilder(command, arg1, arg2, arg3);
            Process p = pb.start();
        }
        catch(IOException ex)
        {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "External Process Error", JOptionPane.ERROR_MESSAGE);
        }
        catch(Exception ex)
        {
            JOptionPane.showMessageDialog(this, "Unexpected Exception, Exiting: "+ ex.getMessage() + "\n" + ex.getStackTrace().toString(), "Phidget21Manager Fatal Exception", JOptionPane.ERROR_MESSAGE);
            dispose();
            System.exit(0);
        }
    }
    private void formWindowOpened(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowOpened
        try
        {
            jLabel3.setText(Phidget.getLibraryVersion());
            
            deviceTbl.getColumnModel().getColumn(0).setPreferredWidth(150);
            deviceTbl.getColumnModel().getColumn(0).setResizable(false);
            deviceTbl.getColumnModel().getColumn(1).setPreferredWidth(80);
            deviceTbl.getColumnModel().getColumn(1).setResizable(false);
            deviceTbl.getColumnModel().getColumn(2).setPreferredWidth(75);
            deviceTbl.getColumnModel().getColumn(2).setResizable(false);
            deviceTbl.getColumnModel().getColumn(3).setPreferredWidth(75);
            deviceTbl.getColumnModel().getColumn(3).setResizable(false);
            deviceTbl.getTableHeader().setReorderingAllowed(false);
            
            deviceTbl.addMouseListener(new MouseAdapter(){
                @Override
                public void mouseClicked(MouseEvent evnt)
                {
                    if(evnt.getClickCount() > 1)
                    {
                        int row = deviceTbl.rowAtPoint(new Point(evnt.getX(), evnt.getY()));
                        int column = deviceTbl.columnAtPoint(new Point(evnt.getX(), evnt.getY()));
                        
                        deviceTblMouseDblClicked(row, column);
                    }
                }
            });
            
            manager = new Manager();
            
            attach_listener = new ManagerAttachListener(this, this.deviceTbl);
            detach_listener = new ManagerDetachListener(this, this.deviceTbl);

            manager.addAttachListener(attach_listener);
            manager.addDetachListener(detach_listener);

            manager.open();
            
        }
        catch(PhidgetException ex)
        {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
        catch(Exception ex)
        {
            JOptionPane.showMessageDialog(this, "Unexpected Exception, Exiting: "+ ex.getMessage() + "\n" + ex.getStackTrace().toString(), "Phidget21Manager Fatal Exception", JOptionPane.ERROR_MESSAGE);
            dispose();
            System.exit(0);
        }
    }//GEN-LAST:event_formWindowOpened

    private void formWindowClosed(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosed
        try
        {
            manager.removeAttachListener(attach_listener);
            manager.removeDetachListener(detach_listener);
            
            manager.close();
            manager = null;
            
            dispose();
            System.exit(0);
        }
        catch(PhidgetException ex)
        {
            JOptionPane.showMessageDialog(null, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
            dispose();
            System.exit(0);
        }
        catch(Exception ex)
        {
            JOptionPane.showMessageDialog(this, "Unexpected Exception, Exiting: "+ ex.getMessage() + "\n" + ex.getStackTrace().toString(), "Phidget21Manager Fatal Exception", JOptionPane.ERROR_MESSAGE);
            dispose();
            System.exit(0);
        }
        
    }//GEN-LAST:event_formWindowClosed
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new PhidgetControlPanel().setVisible(true);
            }
        });
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTable deviceTbl;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables
    
}
